/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.search;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.epf.web.search.EPFHostnameVerifier;
import org.eclipse.epf.web.search.EPFX509TrustManager;
import org.eclipse.epf.web.search.utils.UNCUtil;

public class IndexLoader {
    public static final String VERSION_FILE_NAME = "version.txt";
    public static final String VERSION_DELIMITER = "*";
    public static final String DOWNLOAD_ERROR = "Unable to download index.jar file";
    private static String userIndexFolderName = null;
    private String userIndexPath = null;
    private static String analyzerName;
    private static Map cache;
    protected String m_docBase;
    protected String m_indexFolder;
    protected String m_indexFile;
    protected long tally;
    protected int fileSize;

    static {
        cache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadIndex() {
        byte[] bytes = new byte[16384];
        String product = "";
        File versionFile = null;
        File indexArchive = null;
        try {
            try {
                StringBuffer base = new StringBuffer(this.m_docBase);
                base.append("/search/index/index.jar");
                URL url = new URL(base.toString());
                url = UNCUtil.handleURLForUNC(url);
                System.out.println("IndexLoader.downloadIndex index file: " + url.toString());
                indexArchive = new File(this.m_indexFile);
                indexArchive.getParentFile().mkdirs();
                System.out.println("IndexLoader.downloadIndex local index file: " + indexArchive.getAbsolutePath());
                StringBuffer newIndexFolderName = new StringBuffer(this.m_indexFolder);
                newIndexFolderName.append(userIndexFolderName);
                versionFile = new File(String.valueOf(newIndexFolderName.toString()) + File.separator + VERSION_FILE_NAME);
                FileReader readVersion = new FileReader(versionFile);
                BufferedReader bRead = new BufferedReader(readVersion);
                String versionString = bRead.readLine();
                bRead.close();
                readVersion.close();
                StringTokenizer tok = new StringTokenizer(versionString, VERSION_DELIMITER);
                product = tok.nextToken();
                tok.nextToken();
                this.fileSize = Integer.parseInt(tok.nextToken());
                BufferedInputStream inputS = new BufferedInputStream(url.openStream());
                FileOutputStream writeArchive = new FileOutputStream(indexArchive);
                this.tally = 0L;
                int streamNotAvailable = 0;
                while (this.tally < (long)this.fileSize) {
                    int num = inputS.read(bytes);
                    if (num > 0) {
                        streamNotAvailable = 0;
                        writeArchive.write(bytes, 0, num);
                        this.tally += (long)num;
                        continue;
                    }
                    try {
                        IndexLoader indexLoader = this;
                        synchronized (indexLoader) {
                            this.wait(50L);
                        }
                        if (streamNotAvailable > 100) {
                            System.out.println("time out: Unable to download index.jar file");
                            throw new Exception(DOWNLOAD_ERROR);
                        }
                        ++streamNotAvailable;
                    }
                    catch (Exception e1) {
                        System.out.println("Download index failed");
                        e1.printStackTrace();
                        break;
                    }
                }
                inputS.close();
                writeArchive.close();
                this.tally = 0L;
                ZipInputStream zStream = new ZipInputStream(new FileInputStream(this.m_indexFile));
                ZipEntry zEntry = zStream.getNextEntry();
                while (zEntry != null) {
                    File file = new File(newIndexFolderName.toString(), zEntry.getName());
                    if (zEntry.isDirectory()) {
                        file.mkdir();
                    } else {
                        file.getParentFile().mkdirs();
                        FileOutputStream outs = new FileOutputStream(file);
                        while (zStream.available() > 0) {
                            int num = zStream.read(bytes);
                            if (num <= 0) continue;
                            outs.write(bytes, 0, num);
                        }
                        outs.close();
                        ++this.tally;
                    }
                    zEntry = zStream.getNextEntry();
                }
                zStream.close();
                System.out.println("Completed writing the index files successfully");
            }
            catch (Exception e1) {
                System.out.println(e1.getMessage());
                product = null;
                versionFile.delete();
                e1.printStackTrace();
                if (indexArchive.exists()) {
                    indexArchive.delete();
                }
            }
        }
        finally {
            if (indexArchive.exists()) {
                indexArchive.delete();
            }
        }
        return product;
    }

    public IndexLoader(String documentBase, String indexFolder, String indexFile) {
        this.m_docBase = documentBase;
        this.m_indexFolder = indexFolder;
        this.m_indexFile = indexFile;
        System.out.println("IndexLoader docBase: " + this.m_docBase);
        System.out.println("IndexLoader indexFolder: " + this.m_indexFolder);
        System.out.println("IndexLoader indexFile: " + this.m_indexFile);
    }

    public String checkIndexVersion() throws Exception {
        String siteFolderName = null;
        try {
            int idx;
            URL url = new URL(String.valueOf(this.m_docBase) + "/search/index/version.txt");
            url = UNCUtil.handleURLForUNC(url);
            System.out.println("IndexLoader.checkIndexVersion reading index file: " + url.toString());
            BufferedInputStream inputS = new BufferedInputStream(url.openStream());
            InputStreamReader iStreamReader = new InputStreamReader(inputS);
            BufferedReader read = new BufferedReader(iStreamReader);
            String version = read.readLine();
            int n = idx = version != null ? version.indexOf(VERSION_DELIMITER) : -1;
            if (idx <= -1) {
                throw new FileNotFoundException();
            }
            String localFolderName = version.substring(idx + 1);
            userIndexFolderName = IndexLoader.removeChar(localFolderName, '*');
            String analyzer = read.readLine();
            if (analyzer != null) {
                analyzer = analyzer.trim();
            }
            IndexLoader.setAnalyzerName(analyzer);
            read.close();
            if (userIndexFolderName == null) {
                throw new FileNotFoundException();
            }
            this.userIndexPath = String.valueOf(this.m_indexFolder) + userIndexFolderName;
            System.out.println("IndexLoader.checkIndexVersion userIndexPath: " + this.userIndexPath);
            String userStringVersion = "";
            File userVersion = new File(String.valueOf(this.userIndexPath) + File.separator + VERSION_FILE_NAME);
            System.out.println("IndexLoader.checkIndexVersion userVersion: " + userVersion.getAbsolutePath());
            if (userVersion.exists()) {
                FileReader fRead = new FileReader(userVersion);
                read = new BufferedReader(fRead);
                userStringVersion = read.readLine();
                read.close();
            }
            if (version.equals(userStringVersion)) {
                siteFolderName = userStringVersion.substring(0, userStringVersion.indexOf(VERSION_DELIMITER));
            } else {
                userVersion.delete();
                userVersion.getParentFile().delete();
                userVersion.getParentFile().mkdirs();
                FileWriter fWrite = new FileWriter(userVersion);
                BufferedWriter write = new BufferedWriter(fWrite);
                write.write(String.valueOf(version) + "\n");
                write.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error in IndexLoader.checkIndexVersion: " + e.getMessage());
        }
        catch (Exception e1) {
            System.out.println("Error in IndexLoader.checkIndexVersion: " + e1.getMessage());
            e1.printStackTrace();
        }
        return siteFolderName;
    }

    public static String getSiteFolderName(String documentBase) throws Exception {
        String siteFolderName = (String)cache.get(documentBase);
        if (siteFolderName != null) {
            return siteFolderName;
        }
        try {
            int idx;
            URL url = new URL(String.valueOf(documentBase) + "/search/index/version.txt");
            url = UNCUtil.handleURLForUNC(url);
            BufferedReader in = null;
            if (documentBase.startsWith("http:")) {
                in = new BufferedReader(new InputStreamReader(url.openStream()));
            } else if (documentBase.startsWith("https:")) {
                TrustManager[] tm = new TrustManager[]{new EPFX509TrustManager()};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, tm, null);
                SSLSocketFactory sslFactory = sslContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sslFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new EPFHostnameVerifier());
                in = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            String version = in.readLine();
            int n = idx = version != null ? version.indexOf(VERSION_DELIMITER) : -1;
            if (idx <= -1) {
                throw new FileNotFoundException();
            }
            siteFolderName = version.substring(0, idx);
            cache.put(documentBase, siteFolderName);
            String analyzer = in.readLine();
            if (analyzer != null) {
                analyzer = analyzer.trim();
            }
            IndexLoader.setAnalyzerName(analyzer);
            in.close();
            if (siteFolderName == null) {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return siteFolderName;
    }

    public static String removeChar(String s, char c) {
        String r = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != c) {
                r = String.valueOf(r) + s.charAt(i);
            }
            ++i;
        }
        return r;
    }

    public String getUserIndexPath() {
        return this.userIndexPath;
    }

    public static synchronized String getAnalyzerName() {
        return analyzerName;
    }

    private static synchronized void setAnalyzerName(String analyzerName) {
        IndexLoader.analyzerName = analyzerName;
    }
}

